function [hdr]=rawhdr2hdr(rawhdr)
%[hdr]=rawhdr2hdr(rawhdr)
%convert a rawhdr struct to a hdr struct.
%Input:
% rawhdr: a rawhdr struct variable
%Output:
% hdr: a hdr struct variable
%
%20040318, jdlee
%
hdr.db_name  = rawhdr.hk.db_name;
hdr.dim      = rawhdr.dime.dim(2:4)';
hdr.vox      = rawhdr.dime.pixdim(2:4)';
hdr.scale    = ~rawhdr.dime.funused1 + rawhdr.dime.funused1;
hdr.datatype = dt_num2str(rawhdr.dime.datatype);
hdr.offset   = rawhdr.dime.vox_offset;
hdr.origin   = rawhdr.hist.origin(1:3)';
hdr.descrip  = deblank(rawhdr.hist.descrip);
hdr.byte_order = rawhdr.byte_order;
return